import 'package:play_lab/core/helper/string_format_helper.dart';
import 'package:play_lab/data/model/global/response_model/response_model.dart';
import 'package:play_lab/data/services/api_service.dart';

import '../../../constants/method.dart';
import '../../../core/utils/url_container.dart';

class LiveTvRepo {
  ApiClient apiClient;
  LiveTvRepo({required this.apiClient});

  Future<dynamic> getLiveTv(int page) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.liveTelevisionEndPoint}?page=$page';
    printX(url.toString());
    final response = await apiClient.request(url, Method.getMethod, null);
    printX(response.responseJson);
    return response;
  }

  Future<dynamic> getLiveTvDetails(String tvId) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.liveTvDetailsEndPoint}$tvId';
    final response = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return response;
  }

  Future<dynamic> getLiveTvCommentList(String tvId) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.liveTvCommentsEndPoint}/$tvId';
    final response = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return response;
  }

  Future<dynamic> subscribeChannel(String id) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.buyPlanEndPoint}';
    Map<String, dynamic> params = {'id': id.toString(), 'type': 'channel_category'};
    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, params, passHeader: true);
    return responseModel;
  }

  Future<dynamic> getSubscriptionData() async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.userSubscriptionEndPoint}';
    final response = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return response;
  }

  Future<dynamic> submitComment({
    required String tvId,
    required String comments,
  }) async {
    String url = '${UrlContainer.baseUrl}${UrlContainer.liveTvCommentsEndPoint}';
    Map<String, dynamic> params = {'live_id': tvId, 'comment': comments};
    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, params, passHeader: true);
    return responseModel;
  }
}
